ORCA/M Asm65816 2.1.0

0001 8266              ****************************************************************
0002 8266              ***                                                          ***
0003 8266              ***          Sound Patch                                     ***
0004 8266              ***          For Version 2.0 of ROM                          ***
0005 8266              ***          Copyright Apple Computer, Inc. 1985-1989        ***
0006 8266              ***          All Rights Reserved                             ***
0007 8266              ***                                                          ***
0008 8266              ***                                                          ***
0009 8266              *** Version 2.0 in ROM                                       ***
0010 8266              ***                                                          ***
0011 8266              *** Version 2.1 for system.disk version 3.1                  ***
0012 8266              ***    August 27, 1987                                       ***
0013 8266              ***    Gus Andrade                                           ***
0014 8266              ***                                                          ***
0015 8266              *** Version 2.2 for system.disk 3.1.1                        ***
0016 8266              ***    October 13, 1987                                      ***
0017 8266              ***    Steven Glass                                          ***
0018 8266              ***                                                          ***
0019 8266              ***    Installation code removed and patch linked with       ***
0020 8266              ***    other system patches.                                 ***
0021 8266              ***                                                          ***
0022 8266              ***    Dummy BootInit call placed in table so code           ***
0023 8266              ***    can init properly.                                    ***
0024 8266              ***                                                          ***
0025 8266              ***    Duplicate equate for IRQ_Volume removed in            ***
0026 8266              ***    favor of value in sysEqus (E1Vectors)                 ***
0027 8266              ***                                                          ***
0028 8266              *** Version 2.3 for system disk 3.2                          ***
0029 8266              ***     May 11, 1988                                         ***
0030 8266              ***     Don Marsh                                            ***
0031 8266              ***                                                          ***
0032 8266              ***     Patched Sound Tools' BootInit call to initialize     ***
0033 8266              ***     the "MidiInputPoll" vector to an RTL.                ***
0034 8266              ***                                                          ***
0035 8266              ***     June 15, 1988  Harry Yee                             ***
0036 8266              ***                                                          ***
0037 8266              ***     Prototype bit taken out of version number.           ***
0038 8266              ***                                                          ***
0039 8266              *** Version 2.4 for system disk 4.0                          ***
0040 8266              ***                                                          ***
0041 8266              ***     Changed location of midi poll vector.                ***
0042 8266              ***                                                          ***
0043 8266              ***
0044 8266              ***
0045 8266              *** Version 3.1 for system disk 5.0
0046 8266              *
0047 8266              *
0048 8266              * 20 May 89         Matt Denman
0049 8266              *
0050 8266              *       Patched out interrupt handler to fix two bugs:
0051 8266              *
0052 8266              *       1.  If used in swap mode and only 2 buffers, 2nd
0053 8266              *           was not played.
0054 8266              *
0055 8266              *       2.  If using stero and not balenced the last buffer
0056 8266              *           not played on right channel.
0057 8266              *
0058 8266              *       Re-orgainzed patch so that code in ROM is linked
0059 8266              *       rather than included.
0060 8266              *
0061 8266              *
0062 8266              * 08 Aug 90         Braz
0063 8266              *
0064 8266              * Changed files StartSound.aii and StartPlaying.aii
0065 8266              * to fix problems playing sounds two buffers or less in length
0066 8266              * using FFSetUpSound and FFStartPlaying
0067 8266              *
0068 8266              * 17-Sep-90         Dave Lyons
0069 8266              *
0070 8266              * Removed all.macros dependency.
0071 8266              *
0072 8266              ****************************************************************
0073 8266
0074 8266              ***	Include 'all.macros'	;removed 17-Sep-90 DAL
0075 8266                       include 'm16.util2' 
0076 8266
0077 8266                       Include 'E16.MIDI' 
0078 8266                       Include ':::Sound:Snd.Equ.aii' 
0079 8266
0080 8266
0081 8266              ****************************************************************
0082 8266              ;
0083 8266              ; spatch.equ    This module contains all of the equates used by
0084 8266              ;               the routines in the sound tools patch file
0085 8266              ;
0086 8266              ****************************************************************
0087 8266                                                      ;  MIDI Tool Set
0088 8266              sgaddh   equ $C03F                      ; sound Glu address high
0089 8266
0090 8266
0091 8266              *****************************************************************
0092 8266              *
0093 8266              * SoundCallTable
0094 8266              *
0095 8266              *****************************************************************
0096 8266                       EXPORT SoundCallTable 
0097 8266              SoundCallTable PROC 
0098 8266
0099 8266
0100 8266                       Import SoundBootInit 
0101 8266                       Import st_versin 
0102 8266                       Import StartSound 
0103 8266                       Import SetUpSound 
0104 8266                       Import SStartup 
0105 8266                       IMPORT StartPlaying 
0106 8266
0107 8266 19 00 00 00  Funct_1  DC L:num_funct/4               ; number of functions
0108 826A 08 86 02 00           DC L:SoundBootInit-1           ; function 1
0109 826E 7C 8A 02 00           DC L:SStartup-1                ; function 2
0110 8272 00 00 00 00           DC L:00000000                  ; function 3
0111 8276 14 86 02 00           DC L:st_versin-1               ; function 4
0112 827A 00 00 00 00           DC L:00000000                  ; function 5
0113 827E 00 00 00 00           DC L:00000000                  ; function 6
0114 8282 00 00 00 00           DC L:00000000                  ; function 7
0115 8286 00 00 00 00           DC L:00000000                  ; function 8
0116 828A 00 00 00 00           DC L:00000000                  ; function 9
0117 828E 00 00 00 00           DC L:00000000                  ; function A
0118 8292 00 00 00 00           DC L:00000000                  ; function B
0119 8296 00 00 00 00           DC L:00000000                  ; function C
0120 829A 00 00 00 00           DC L:00000000                  ; function D
0121 829E 33 86 02 00           DC L:StartSound-1              ; function E
0122 82A2 00 00 00 00           DC L:00000000                  ; function F
0123 82A6 00 00 00 00           DC L:00000000                  ; function 10
0124 82AA 00 00 00 00           DC L:00000000                  ; function 11
0125 82AE 00 00 00 00           DC L:00000000                  ; function 12
0126 82B2 00 00 00 00           DC L:00000000                  ; function 13
0127 82B6 00 00 00 00           DC L:00000000                  ; function 14
0128 82BA 23 86 02 00           DC L:SetUpSound-1              ; function 15 
0129 82BE 1B 8A 02 00           DC L:StartPlaying-1            ; 16 Start specified generators running.
0130 82C2 00 00 00 00           DC L:00000000                  ; function 17
0131 82C6 00 00 00 00           DC L:00000000                  ; function 18
0132 82CA
0133 82CA              num_funct equ   *-Funct_1               ; number of functions
0134 82CA
0135 82CA
0136 82CA                       TITLE 'Oscillator table' 
0137 82CA                       EJECT 
0138 82CA              ************************************************************
0139 82CA              *
0140 82CA              * Table of Physical DOC oscillator #'s indexed by
0141 82CA              * the logical Sound generator number (0-f)
0142 82CA              *
0143 82CA              * Entries point to the first osc of each osc-pair
0144 82CA              * used as a sound generator
0145 82CA              *
0146 82CA              ************************************************************
0147 82CA                       export Osctable 
0148 82CA              Osctable                                ;
0149 82CA 00 10 08 18           DC B:$00,$10,$08,$18
0150 82CE 04 14 0C 1C           DC B:$04,$14,$0C,$1C
0151 82D2 02 12 0A 1A           DC B:$02,$12,$0A,$1A
0152 82D6 06 16 0E 1E           DC B:$06,$16,$0E,$1E
0153 82DA              ;
0154 82DA              ;
0155 82DA                       TITLE 'Generator table' 
0156 82DA                       EJECT 
0157 82DA              ************************************************************
0158 82DA              *
0159 82DA              * Gen.table: Table of Physical sound generator #'s indexed by
0160 82DA              *            the DOC oscillator number $00-$1F.
0161 82DA              *            Entries point to generator number for that pair of oscs.
0162 82DA              *
0163 82DA              ************************************************************
0164 82DA                       export Gentable 
0165 82DA              Gentable                                ;
0166 82DA 00 00                 DC B:$00,$00                   ; osc # $00,$01
0167 82DC 08 08                 DC B:$08,$08                   ; osc # $02,$03
0168 82DE 04 04                 DC B:$04,$04                   ; osc # $04,$05
0169 82E0 0C 0C                 DC B:$0C,$0C                   ; osc # $06,$07
0170 82E2 02 02                 DC B:$02,$02                   ; osc # $08,$09
0171 82E4 0A 0A                 DC B:$0A,$0A                   ; osc # $0A,$0B
0172 82E6 06 06                 DC B:$06,$06                   ; osc # $0C,$0D
0173 82E8 0E 0E                 DC B:$0E,$0E                   ; osc # $0E,$0F
0174 82EA 01 01                 DC B:$01,$01                   ; osc # $10,$11
0175 82EC 09 09                 DC B:$09,$09                   ; osc # $12,$13
0176 82EE 05 05                 DC B:$05,$05                   ; osc # $14,$15
0177 82F0 0D 0D                 DC B:$0D,$0D                   ; osc # $16,$17
0178 82F2 03 03                 DC B:$03,$03                   ; osc # $18,$19
0179 82F4 0B 0B                 DC B:$0B,$0B                   ; osc # $1A,$1B
0180 82F6 07 07                 DC B:$07,$07                   ; osc # $1C,$1D
0181 82F8 0F 0F                 DC B:$0F,$0F                   ; osc # $1E,$1F
0182 82FA              ;
0183 82FA              ;
0184 82FA                       TITLE 'Gen # to gcg addr table' 
0185 82FA                       EJECT 
0186 82FA              ********************************************************
0187 82FA              *
0188 82FA              * gcb.xlate: This table translates the gen number into a gcb entry
0189 82FA              *            address.
0190 82FA              *
0191 82FA              *     Import: X = generator number
0192 82FA              *
0193 82FA              *     Export: X = gcb start addr corresponding to gen #
0194 82FA              *
0195 82FA              ********************************************************
0196 82FA              ;
0197 82FA              ;
0198 82FA                       export gcb_xlate 
0199 82FA              gcb_xlate                               ;
0200 82FA 00                    DC B:gen0_gcb                  ;
0201 82FB 10                    DC B:gen1_gcb                  ;
0202 82FC 20                    DC B:gen2_gcb                  ;
0203 82FD 30                    DC B:gen3_gcb                  ;
0204 82FE 40                    DC B:gen4_gcb                  ;
0205 82FF 50                    DC B:gen5_gcb                  ;
0206 8300 60                    DC B:gen6_gcb                  ;
0207 8301 70                    DC B:gen7_gcb                  ;
0208 8302 80                    DC B:gen8_gcb                  ;
0209 8303 90                    DC B:gen9_gcb                  ;
0210 8304 A0                    DC B:genA_gcb                  ;
0211 8305 B0                    DC B:genB_gcb                  ;
0212 8306 C0                    DC B:genC_gcb                  ;
0213 8307 D0                    DC B:genD_gcb                  ;
0214 8308 E0                    DC B:genE_gcb                  ;
0215 8309
0216 8309                       ENDP 
0217 8309
0218 8309
0219 8309              *****************************************************************
0220 8309              *
0221 8309              * SoundBootInit
0222 8309              *
0223 8309              * This routine is called by the tool locator when this patch
0224 8309              * is installed.
0225 8309              *
0226 8309              * Added 13 Oct 87   Steven Glass
0227 8309              *
0228 8309              * 13 May 88         Harry Yee and Don Marsh
0229 8309              *
0230 8309              * Added initialization of MidiInputPoll vector.
0231 8309              *
0232 8309              *****************************************************************
0233 8309                       EXPORT SoundBootInit 
0234 8309              SoundBootInit PROC 
0235 8309
0236 8309 A9 6B 00              lda   #$6B                     ; RTL
0237 830C 8F B2 01 E1           sta   MidiInputPoll
0238 8310
0239 8310 A9 00 00              lda   #0
0240 8313 18                    clc   
0241 8314 6B                    rtl   
0242 8315
0243 8315                       ENDP 
0244 8315
0245 8315
0246 8315
0247 8315
0248 8315                       EXPORT st_versin 
0249 8315              st_versin PROC 
0250 8315              ****************************************************************
0251 8315              *
0252 8315              * Version number tool returns the current Sound Tool
0253 8315              * version #.
0254 8315              *
0255 8315              *    Called:  pea 0 ; return value placeholder
0256 8315              *             Toolcall 8,4
0257 8315              *
0258 8315              * Returns: X,Y unchanged.  Version on stack
0259 8315              *
0260 8315              *
0261 8315              ****************************************************************
0262 8315
0263 8315                       longa on 
0264 8315                       longi on 
0265 8315 A9 03 03              lda   #Version_patch           ; get vers#
0266 8318 83 07                 sta   $07,s                    ; place in stack
0267 831A A0 00 00 A2           Oendc 0                        ; jump to endcall in rom
0268 8324
0269 8324                       ENDP 
0270 8324
0271 8324                       END   
